package mole.entities 
{
	import mole.Main;
	import net.flashpunk.graphics.Image;
	import net.flashpunk.Entity;
	import net.flashpunk.FP;
	import net.flashpunk.graphics.Spritemap;
	import net.flashpunk.Sfx;
	/**
	 * Wouf
	 * @author Cédric Liaudet
	 */
	public class CLassie extends Entity
	{
		[Embed(source = '../../data/images/objects/scie.png')]
		static public const ASSET:Class;
		
		[Embed(source = '../../data/sounds/Mole_Saw_Loop.mp3')]
		static public const SOUND:Class;
		
		[Embed(source = '../../data/images/objects/scie_cylindre.png')]
		static public const CYLINDRE:Class;
		
		public function CLassie() 
		{
			x = 0;
			y = 192;
			
			var spriteMap:Spritemap = new Spritemap(ASSET, 256, 192);
			spriteMap.add("run", [0, 1, 2, 3, 4, 5], 30, true);
			spriteMap.play("run");
			
			width = 256;
			height = 192;
			graphic = spriteMap;
			layer = 5;
			type = "perforator";
			
			m_Sfx = new Sfx(SOUND);
			m_Sfx.loop(0, -1);
			
			m_Cylindre = Main.World.addGraphic(new Image(CYLINDRE), 5);
			m_Cylindre.x = x - 1024;
			m_Cylindre.y = 192;
		}
		
		public function SetVolume(_Volume:Number):void
		{
			m_Sfx.volume = _Volume;
		}
		
		public function Stop():void
		{
			m_Sfx.stop();
			m_Sfx = null;
		}
		
		override public function update():void
		{
			x += 2 * FP.elapsed;
			
			m_Cylindre.x = x - 1024;
		}
		
		private var m_Sfx:Sfx;
		private var m_Cylindre:Entity;
	}

}